package org.msh.tb.reports2.variables;

import org.msh.reports.keys.Key;
import org.msh.reports.query.SQLDefs;
import org.msh.tb.entities.enums.CaseDefinition;
import org.msh.tb.entities.enums.PatientType;
import org.msh.tb.reports2.VariableImpl;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 20/12/16.
 */
public class SputumConversionVariable extends VariableImpl {

    private static final String KEY_NEW = "0-new";
    private static final String KEY_PREVTREAT = "1-prev-treat";
    private static final String KEY_BAC_DIAGNOSED = "2-bac-diagnosed";


    public SputumConversionVariable() {
        super("sputum-conv", "manag.reportgen.var.sputumconv", null, UnitType.CASE_ONLY);
    }

    @Override
    public void prepareVariableQuery(SQLDefs def, int iteration) {
        def.select("patientType");
    }

    @Override
    public Key createKey(Object values, int iteration) {
        PatientType patientType = values != null ?
                PatientType.values()[(Integer)values] :
                null;

        return Key.of(patientType == PatientType.NEW ? KEY_NEW : KEY_PREVTREAT);
    }

    @Override
    public String getDisplayText(Key key) {
        if (key.isNull()) {
            return super.getDisplayText(key);
        }

        String val = (String)key.getValue();

        if (KEY_NEW.equals(val)) {
            return "New PTB cases";
        }

        if (KEY_PREVTREAT.equals(val)) {
            return "Previously treated PTB cases";
        }

        return "undefined";
    }


}
